/********************************************
/*		   LOOT MODEL FILE CONVERTER
/*  Let's you convert an OBJ to .lmf that's
/*  parsed by Loot & used in places like
/*  the weaponhud.
********************************************/

#include <Windows.h>
#include <stdio.h>
#include "main.h"

using namespace System;
using namespace System::Windows::Forms;

int main( int argc, char** argv ) {
	char fname[128];
	char* ext;

	if( argc < 2 ) {
		printf( "Not enough parameters specified...\n" );
		return FALSE;
	}
	strcpy( fname, argv[1] ); //redundant?
	ext = strchr( fname, '.' );

	if( !ext ) {
		printf( "No extension located in the provided filename...\n" );
		return FALSE;
	}
	
	// Check if the file format extension is valid
	if( !stricmp(ext+1, "obj") ) M_LoadOBJ( fname );
	else if( !stricmp(ext+1, "lmf") ) M_LoadLMF( fname );
	else {
		printf( "Unrecognized file format: %s\n", ext+1 );
		return FALSE;
	}

	if( argc > 2 && !stricmp(ext+1, "obj") ) { // If we have a third argument assume it's a filename for conversion
		strcpy( fname, argv[2] );
		M_ConvertToLMF( fname );
	}

	Application::Run( gcnew lmfeffort::main() );
	return TRUE;
}